package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTransitGatewayMulticastDomainProps {

  def apply(
    transitGatewayId: String,
    options: Option[AnyRef] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.ec2.CfnTransitGatewayMulticastDomainProps =
    (new software.amazon.awscdk.services.ec2.CfnTransitGatewayMulticastDomainProps.Builder)
      .transitGatewayId(transitGatewayId)
      .options(options.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
