package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object UserVerificationConfig {

  def apply(
    smsMessage: Option[String] = None,
    emailSubject: Option[String] = None,
    emailBody: Option[String] = None,
    emailStyle: Option[software.amazon.awscdk.services.cognito.VerificationEmailStyle] = None
  ): software.amazon.awscdk.services.cognito.UserVerificationConfig =
    (new software.amazon.awscdk.services.cognito.UserVerificationConfig.Builder)
      .smsMessage(smsMessage.orNull)
      .emailSubject(emailSubject.orNull)
      .emailBody(emailBody.orNull)
      .emailStyle(emailStyle.orNull)
      .build()
}
