package io.burkard.cdk.services.codepipeline.actions

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CodeBuildAction {

  def apply(
    project: software.amazon.awscdk.services.codebuild.IProject,
    input: software.amazon.awscdk.services.codepipeline.Artifact,
    executeBatchBuild: Option[Boolean] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    extraInputs: Option[List[_ <: software.amazon.awscdk.services.codepipeline.Artifact]] = None,
    combineBatchBuildArtifacts: Option[Boolean] = None,
    environmentVariables: Option[Map[String, _ <: software.amazon.awscdk.services.codebuild.BuildEnvironmentVariable]] = None,
    outputs: Option[List[_ <: software.amazon.awscdk.services.codepipeline.Artifact]] = None,
    variablesNamespace: Option[String] = None,
    runOrder: Option[Number] = None,
    actionName: Option[String] = None,
    `type`: Option[software.amazon.awscdk.services.codepipeline.actions.CodeBuildActionType] = None,
    checkSecretsInPlainTextEnvVariables: Option[Boolean] = None
  ): software.amazon.awscdk.services.codepipeline.actions.CodeBuildAction =
    software.amazon.awscdk.services.codepipeline.actions.CodeBuildAction.Builder
      .create()
      .project(project)
      .input(input)
      .executeBatchBuild(executeBatchBuild.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .role(role.orNull)
      .extraInputs(extraInputs.map(_.asJava).orNull)
      .combineBatchBuildArtifacts(combineBatchBuildArtifacts.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .environmentVariables(environmentVariables.map(_.asJava).orNull)
      .outputs(outputs.map(_.asJava).orNull)
      .variablesNamespace(variablesNamespace.orNull)
      .runOrder(runOrder.orNull)
      .actionName(actionName.orNull)
      .`type`(`type`.orNull)
      .checkSecretsInPlainTextEnvVariables(checkSecretsInPlainTextEnvVariables.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
