package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HttpHealthCheckOptions {

  def apply(
    path: Option[String] = None,
    healthyThreshold: Option[Number] = None,
    unhealthyThreshold: Option[Number] = None,
    interval: Option[software.amazon.awscdk.Duration] = None,
    timeout: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.appmesh.HttpHealthCheckOptions =
    (new software.amazon.awscdk.services.appmesh.HttpHealthCheckOptions.Builder)
      .path(path.orNull)
      .healthyThreshold(healthyThreshold.orNull)
      .unhealthyThreshold(unhealthyThreshold.orNull)
      .interval(interval.orNull)
      .timeout(timeout.orNull)
      .build()
}
