package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HttpGatewayListenerOptions {

  def apply(
    port: Option[Number] = None,
    connectionPool: Option[software.amazon.awscdk.services.appmesh.HttpConnectionPool] = None,
    healthCheck: Option[software.amazon.awscdk.services.appmesh.HealthCheck] = None,
    tls: Option[software.amazon.awscdk.services.appmesh.ListenerTlsOptions] = None
  ): software.amazon.awscdk.services.appmesh.HttpGatewayListenerOptions =
    (new software.amazon.awscdk.services.appmesh.HttpGatewayListenerOptions.Builder)
      .port(port.orNull)
      .connectionPool(connectionPool.orNull)
      .healthCheck(healthCheck.orNull)
      .tls(tls.orNull)
      .build()
}
