package io.burkard.cdk.services.amplifyuibuilder

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnThemeProps {

  def apply(
    name: String,
    values: List[_],
    tags: Option[Map[String, String]] = None,
    overrides: Option[List[_]] = None
  ): software.amazon.awscdk.services.amplifyuibuilder.CfnThemeProps =
    (new software.amazon.awscdk.services.amplifyuibuilder.CfnThemeProps.Builder)
      .name(name)
      .values(values.asJava)
      .tags(tags.map(_.asJava).orNull)
      .overrides(overrides.map(_.asJava).orNull)
      .build()
}
