package io.burkard.cdk.services.acmpca

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPermissionProps {

  def apply(
    actions: List[String],
    principal: String,
    certificateAuthorityArn: String,
    sourceAccount: Option[String] = None
  ): software.amazon.awscdk.services.acmpca.CfnPermissionProps =
    (new software.amazon.awscdk.services.acmpca.CfnPermissionProps.Builder)
      .actions(actions.asJava)
      .principal(principal)
      .certificateAuthorityArn(certificateAuthorityArn)
      .sourceAccount(sourceAccount.orNull)
      .build()
}
