package io.burkard.cdk.services.ses

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnReceiptRule {

  def apply(
    internalResourceId: String,
    rule: software.amazon.awscdk.services.ses.CfnReceiptRule.RuleProperty,
    ruleSetName: String,
    after: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ses.CfnReceiptRule =
    software.amazon.awscdk.services.ses.CfnReceiptRule.Builder
      .create(stackCtx, internalResourceId)
      .rule(rule)
      .ruleSetName(ruleSetName)
      .after(after.orNull)
      .build()
}
