package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPortfolioProductAssociationProps {

  def apply(
    productId: String,
    portfolioId: String,
    acceptLanguage: Option[String] = None,
    sourcePortfolioId: Option[String] = None
  ): software.amazon.awscdk.services.servicecatalog.CfnPortfolioProductAssociationProps =
    (new software.amazon.awscdk.services.servicecatalog.CfnPortfolioProductAssociationProps.Builder)
      .productId(productId)
      .portfolioId(portfolioId)
      .acceptLanguage(acceptLanguage.orNull)
      .sourcePortfolioId(sourcePortfolioId.orNull)
      .build()
}
