package io.burkard.cdk.services.sam.cfnFunction

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AuthProperty {

  def apply(
    authorizationScopes: Option[List[String]] = None,
    authorizer: Option[String] = None,
    apiKeyRequired: Option[Boolean] = None,
    resourcePolicy: Option[software.amazon.awscdk.services.sam.CfnFunction.AuthResourcePolicyProperty] = None
  ): software.amazon.awscdk.services.sam.CfnFunction.AuthProperty =
    (new software.amazon.awscdk.services.sam.CfnFunction.AuthProperty.Builder)
      .authorizationScopes(authorizationScopes.map(_.asJava).orNull)
      .authorizer(authorizer.orNull)
      .apiKeyRequired(apiKeyRequired.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .resourcePolicy(resourcePolicy.orNull)
      .build()
}
