package io.burkard.cdk.services.s3

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BlockPublicAccess {

  def apply(
    blockPublicAcls: Boolean,
    ignorePublicAcls: Boolean,
    restrictPublicBuckets: Boolean,
    blockPublicPolicy: Boolean
  ): software.amazon.awscdk.services.s3.BlockPublicAccess =
    software.amazon.awscdk.services.s3.BlockPublicAccess.Builder
      .create()
      .blockPublicAcls(blockPublicAcls)
      .ignorePublicAcls(ignorePublicAcls)
      .restrictPublicBuckets(restrictPublicBuckets)
      .blockPublicPolicy(blockPublicPolicy)
      .build()
}
