package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSMSChannelProps {

  def apply(
    applicationId: String,
    enabled: Option[Boolean] = None,
    senderId: Option[String] = None,
    shortCode: Option[String] = None
  ): software.amazon.awscdk.services.pinpoint.CfnSMSChannelProps =
    (new software.amazon.awscdk.services.pinpoint.CfnSMSChannelProps.Builder)
      .applicationId(applicationId)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .senderId(senderId.orNull)
      .shortCode(shortCode.orNull)
      .build()
}
