package io.burkard.cdk.services.networkmanager

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCustomerGatewayAssociationProps {

  def apply(
    deviceId: String,
    globalNetworkId: String,
    customerGatewayArn: String,
    linkId: Option[String] = None
  ): software.amazon.awscdk.services.networkmanager.CfnCustomerGatewayAssociationProps =
    (new software.amazon.awscdk.services.networkmanager.CfnCustomerGatewayAssociationProps.Builder)
      .deviceId(deviceId)
      .globalNetworkId(globalNetworkId)
      .customerGatewayArn(customerGatewayArn)
      .linkId(linkId.orNull)
      .build()
}
