package io.burkard.cdk.services.lambda.eventsources

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SqsEventSourceProps {

  def apply(
    enabled: Option[Boolean] = None,
    batchSize: Option[Number] = None,
    maxBatchingWindow: Option[software.amazon.awscdk.Duration] = None,
    reportBatchItemFailures: Option[Boolean] = None
  ): software.amazon.awscdk.services.lambda.eventsources.SqsEventSourceProps =
    (new software.amazon.awscdk.services.lambda.eventsources.SqsEventSourceProps.Builder)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .batchSize(batchSize.orNull)
      .maxBatchingWindow(maxBatchingWindow.orNull)
      .reportBatchItemFailures(reportBatchItemFailures.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
