package io.burkard.cdk.services.kinesisfirehose.cfnDeliveryStream

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ElasticsearchDestinationConfigurationProperty {

  def apply(
    s3Configuration: software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty,
    roleArn: String,
    indexName: String,
    domainArn: Option[String] = None,
    indexRotationPeriod: Option[String] = None,
    cloudWatchLoggingOptions: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty] = None,
    typeName: Option[String] = None,
    vpcConfiguration: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.VpcConfigurationProperty] = None,
    retryOptions: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchRetryOptionsProperty] = None,
    clusterEndpoint: Option[String] = None,
    bufferingHints: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchBufferingHintsProperty] = None,
    processingConfiguration: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty] = None,
    s3BackupMode: Option[String] = None
  ): software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty =
    (new software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.Builder)
      .s3Configuration(s3Configuration)
      .roleArn(roleArn)
      .indexName(indexName)
      .domainArn(domainArn.orNull)
      .indexRotationPeriod(indexRotationPeriod.orNull)
      .cloudWatchLoggingOptions(cloudWatchLoggingOptions.orNull)
      .typeName(typeName.orNull)
      .vpcConfiguration(vpcConfiguration.orNull)
      .retryOptions(retryOptions.orNull)
      .clusterEndpoint(clusterEndpoint.orNull)
      .bufferingHints(bufferingHints.orNull)
      .processingConfiguration(processingConfiguration.orNull)
      .s3BackupMode(s3BackupMode.orNull)
      .build()
}
