package io.burkard.cdk.services.kinesisfirehose

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDeliveryStream {

  def apply(
    internalResourceId: String,
    kinesisStreamSourceConfiguration: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.KinesisStreamSourceConfigurationProperty] = None,
    deliveryStreamEncryptionConfigurationInput: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    extendedS3DestinationConfiguration: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty] = None,
    redshiftDestinationConfiguration: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.RedshiftDestinationConfigurationProperty] = None,
    httpEndpointDestinationConfiguration: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty] = None,
    elasticsearchDestinationConfiguration: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty] = None,
    splunkDestinationConfiguration: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SplunkDestinationConfigurationProperty] = None,
    deliveryStreamName: Option[String] = None,
    s3DestinationConfiguration: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty] = None,
    deliveryStreamType: Option[String] = None,
    amazonopensearchserviceDestinationConfiguration: Option[software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceDestinationConfigurationProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream =
    software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.Builder
      .create(stackCtx, internalResourceId)
      .kinesisStreamSourceConfiguration(kinesisStreamSourceConfiguration.orNull)
      .deliveryStreamEncryptionConfigurationInput(deliveryStreamEncryptionConfigurationInput.orNull)
      .tags(tags.map(_.asJava).orNull)
      .extendedS3DestinationConfiguration(extendedS3DestinationConfiguration.orNull)
      .redshiftDestinationConfiguration(redshiftDestinationConfiguration.orNull)
      .httpEndpointDestinationConfiguration(httpEndpointDestinationConfiguration.orNull)
      .elasticsearchDestinationConfiguration(elasticsearchDestinationConfiguration.orNull)
      .splunkDestinationConfiguration(splunkDestinationConfiguration.orNull)
      .deliveryStreamName(deliveryStreamName.orNull)
      .s3DestinationConfiguration(s3DestinationConfiguration.orNull)
      .deliveryStreamType(deliveryStreamType.orNull)
      .amazonopensearchserviceDestinationConfiguration(amazonopensearchserviceDestinationConfiguration.orNull)
      .build()
}
