package io.burkard.cdk.services.kinesisanalytics.cfnApplicationV2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CheckpointConfigurationProperty {

  def apply(
    configurationType: String,
    checkpointInterval: Option[Number] = None,
    checkpointingEnabled: Option[Boolean] = None,
    minPauseBetweenCheckpoints: Option[Number] = None
  ): software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CheckpointConfigurationProperty =
    (new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CheckpointConfigurationProperty.Builder)
      .configurationType(configurationType)
      .checkpointInterval(checkpointInterval.orNull)
      .checkpointingEnabled(checkpointingEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .minPauseBetweenCheckpoints(minPauseBetweenCheckpoints.orNull)
      .build()
}
