package io.burkard.cdk.services.kendra.cfnIndex

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RelevanceProperty {

  def apply(
    duration: Option[String] = None,
    importance: Option[Number] = None,
    freshness: Option[Boolean] = None,
    rankOrder: Option[String] = None,
    valueImportanceItems: Option[List[_]] = None
  ): software.amazon.awscdk.services.kendra.CfnIndex.RelevanceProperty =
    (new software.amazon.awscdk.services.kendra.CfnIndex.RelevanceProperty.Builder)
      .duration(duration.orNull)
      .importance(importance.orNull)
      .freshness(freshness.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .rankOrder(rankOrder.orNull)
      .valueImportanceItems(valueImportanceItems.map(_.asJava).orNull)
      .build()
}
