package io.burkard.cdk.services.greengrass.cfnFunctionDefinitionVersion

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EnvironmentProperty {

  def apply(
    execution: Option[software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.ExecutionProperty] = None,
    resourceAccessPolicies: Option[List[_]] = None,
    accessSysfs: Option[Boolean] = None,
    variables: Option[AnyRef] = None
  ): software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.EnvironmentProperty =
    (new software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.EnvironmentProperty.Builder)
      .execution(execution.orNull)
      .resourceAccessPolicies(resourceAccessPolicies.map(_.asJava).orNull)
      .accessSysfs(accessSysfs.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .variables(variables.orNull)
      .build()
}
