package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CommonTaskDefinitionAttributes {

  def apply(
    taskDefinitionArn: String,
    networkMode: Option[software.amazon.awscdk.services.ecs.NetworkMode] = None,
    taskRole: Option[software.amazon.awscdk.services.iam.IRole] = None
  ): software.amazon.awscdk.services.ecs.CommonTaskDefinitionAttributes =
    (new software.amazon.awscdk.services.ecs.CommonTaskDefinitionAttributes.Builder)
      .taskDefinitionArn(taskDefinitionArn)
      .networkMode(networkMode.orNull)
      .taskRole(taskRole.orNull)
      .build()
}
