package io.burkard.cdk.services.ec2.cfnSpotFleet

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SpotFleetRequestConfigDataProperty {

  def apply(
    iamFleetRole: String,
    targetCapacity: Number,
    onDemandTargetCapacity: Option[Number] = None,
    onDemandMaxTotalPrice: Option[String] = None,
    allocationStrategy: Option[String] = None,
    launchTemplateConfigs: Option[List[_]] = None,
    validUntil: Option[String] = None,
    context: Option[String] = None,
    instanceInterruptionBehavior: Option[String] = None,
    instancePoolsToUseCount: Option[Number] = None,
    onDemandAllocationStrategy: Option[String] = None,
    validFrom: Option[String] = None,
    loadBalancersConfig: Option[software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty] = None,
    launchSpecifications: Option[List[_]] = None,
    spotMaxTotalPrice: Option[String] = None,
    excessCapacityTerminationPolicy: Option[String] = None,
    replaceUnhealthyInstances: Option[Boolean] = None,
    `type`: Option[String] = None,
    terminateInstancesWithExpiration: Option[Boolean] = None,
    spotMaintenanceStrategies: Option[software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotMaintenanceStrategiesProperty] = None,
    spotPrice: Option[String] = None,
    targetCapacityUnitType: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty =
    (new software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty.Builder)
      .iamFleetRole(iamFleetRole)
      .targetCapacity(targetCapacity)
      .onDemandTargetCapacity(onDemandTargetCapacity.orNull)
      .onDemandMaxTotalPrice(onDemandMaxTotalPrice.orNull)
      .allocationStrategy(allocationStrategy.orNull)
      .launchTemplateConfigs(launchTemplateConfigs.map(_.asJava).orNull)
      .validUntil(validUntil.orNull)
      .context(context.orNull)
      .instanceInterruptionBehavior(instanceInterruptionBehavior.orNull)
      .instancePoolsToUseCount(instancePoolsToUseCount.orNull)
      .onDemandAllocationStrategy(onDemandAllocationStrategy.orNull)
      .validFrom(validFrom.orNull)
      .loadBalancersConfig(loadBalancersConfig.orNull)
      .launchSpecifications(launchSpecifications.map(_.asJava).orNull)
      .spotMaxTotalPrice(spotMaxTotalPrice.orNull)
      .excessCapacityTerminationPolicy(excessCapacityTerminationPolicy.orNull)
      .replaceUnhealthyInstances(replaceUnhealthyInstances.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .`type`(`type`.orNull)
      .terminateInstancesWithExpiration(terminateInstancesWithExpiration.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .spotMaintenanceStrategies(spotMaintenanceStrategies.orNull)
      .spotPrice(spotPrice.orNull)
      .targetCapacityUnitType(targetCapacityUnitType.orNull)
      .build()
}
