package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Port {

  def apply(
    protocol: software.amazon.awscdk.services.ec2.Protocol,
    stringRepresentation: String,
    fromPort: Option[Number] = None,
    toPort: Option[Number] = None
  ): software.amazon.awscdk.services.ec2.Port =
    software.amazon.awscdk.services.ec2.Port.Builder
      .create()
      .protocol(protocol)
      .stringRepresentation(stringRepresentation)
      .fromPort(fromPort.orNull)
      .toPort(toPort.orNull)
      .build()
}
