package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ConnectionRule {

  def apply(
    fromPort: Number,
    protocol: Option[String] = None,
    description: Option[String] = None,
    toPort: Option[Number] = None
  ): software.amazon.awscdk.services.ec2.ConnectionRule =
    (new software.amazon.awscdk.services.ec2.ConnectionRule.Builder)
      .fromPort(fromPort)
      .protocol(protocol.orNull)
      .description(description.orNull)
      .toPort(toPort.orNull)
      .build()
}
