package io.burkard.cdk.services.config

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnOrganizationConfigRuleProps {

  def apply(
    organizationConfigRuleName: String,
    excludedAccounts: Option[List[String]] = None,
    organizationCustomRuleMetadata: Option[software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty] = None,
    organizationManagedRuleMetadata: Option[software.amazon.awscdk.services.config.CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty] = None
  ): software.amazon.awscdk.services.config.CfnOrganizationConfigRuleProps =
    (new software.amazon.awscdk.services.config.CfnOrganizationConfigRuleProps.Builder)
      .organizationConfigRuleName(organizationConfigRuleName)
      .excludedAccounts(excludedAccounts.map(_.asJava).orNull)
      .organizationCustomRuleMetadata(organizationCustomRuleMetadata.orNull)
      .organizationManagedRuleMetadata(organizationManagedRuleMetadata.orNull)
      .build()
}
