package io.burkard.cdk.services.codebuild

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSourceCredentialProps {

  def apply(
    token: String,
    authType: String,
    serverType: String,
    username: Option[String] = None
  ): software.amazon.awscdk.services.codebuild.CfnSourceCredentialProps =
    (new software.amazon.awscdk.services.codebuild.CfnSourceCredentialProps.Builder)
      .token(token)
      .authType(authType)
      .serverType(serverType)
      .username(username.orNull)
      .build()
}
