package io.burkard.cdk.services.ce

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCostCategory {

  def apply(
    internalResourceId: String,
    name: String,
    ruleVersion: String,
    rules: String,
    splitChargeRules: Option[String] = None,
    defaultValue: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ce.CfnCostCategory =
    software.amazon.awscdk.services.ce.CfnCostCategory.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .ruleVersion(ruleVersion)
      .rules(rules)
      .splitChargeRules(splitChargeRules.orNull)
      .defaultValue(defaultValue.orNull)
      .build()
}
