package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SignalsOptions {

  def apply(
    timeout: Option[software.amazon.awscdk.Duration] = None,
    minSuccessPercentage: Option[Number] = None
  ): software.amazon.awscdk.services.autoscaling.SignalsOptions =
    (new software.amazon.awscdk.services.autoscaling.SignalsOptions.Builder)
      .timeout(timeout.orNull)
      .minSuccessPercentage(minSuccessPercentage.orNull)
      .build()
}
