package io.burkard.cdk.services.autoscaling

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnScalingPolicyProps {

  def apply(
    autoScalingGroupName: String,
    stepAdjustments: Option[List[_]] = None,
    minAdjustmentMagnitude: Option[Number] = None,
    metricAggregationType: Option[String] = None,
    scalingAdjustment: Option[Number] = None,
    policyType: Option[String] = None,
    cooldown: Option[String] = None,
    targetTrackingConfiguration: Option[software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.TargetTrackingConfigurationProperty] = None,
    estimatedInstanceWarmup: Option[Number] = None,
    adjustmentType: Option[String] = None,
    predictiveScalingConfiguration: Option[software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.PredictiveScalingConfigurationProperty] = None
  ): software.amazon.awscdk.services.autoscaling.CfnScalingPolicyProps =
    (new software.amazon.awscdk.services.autoscaling.CfnScalingPolicyProps.Builder)
      .autoScalingGroupName(autoScalingGroupName)
      .stepAdjustments(stepAdjustments.map(_.asJava).orNull)
      .minAdjustmentMagnitude(minAdjustmentMagnitude.orNull)
      .metricAggregationType(metricAggregationType.orNull)
      .scalingAdjustment(scalingAdjustment.orNull)
      .policyType(policyType.orNull)
      .cooldown(cooldown.orNull)
      .targetTrackingConfiguration(targetTrackingConfiguration.orNull)
      .estimatedInstanceWarmup(estimatedInstanceWarmup.orNull)
      .adjustmentType(adjustmentType.orNull)
      .predictiveScalingConfiguration(predictiveScalingConfiguration.orNull)
      .build()
}
