package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BasicLifecycleHookProps {

  def apply(
    lifecycleTransition: software.amazon.awscdk.services.autoscaling.LifecycleTransition,
    heartbeatTimeout: Option[software.amazon.awscdk.Duration] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    notificationMetadata: Option[String] = None,
    notificationTarget: Option[software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget] = None,
    defaultResult: Option[software.amazon.awscdk.services.autoscaling.DefaultResult] = None,
    lifecycleHookName: Option[String] = None
  ): software.amazon.awscdk.services.autoscaling.BasicLifecycleHookProps =
    (new software.amazon.awscdk.services.autoscaling.BasicLifecycleHookProps.Builder)
      .lifecycleTransition(lifecycleTransition)
      .heartbeatTimeout(heartbeatTimeout.orNull)
      .role(role.orNull)
      .notificationMetadata(notificationMetadata.orNull)
      .notificationTarget(notificationTarget.orNull)
      .defaultResult(defaultResult.orNull)
      .lifecycleHookName(lifecycleHookName.orNull)
      .build()
}
