package io.burkard.cdk.services.athena

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDataCatalog {

  def apply(
    internalResourceId: String,
    name: String,
    `type`: String,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    parameters: Option[Map[String, String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.athena.CfnDataCatalog =
    software.amazon.awscdk.services.athena.CfnDataCatalog.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .`type`(`type`)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .parameters(parameters.map(_.asJava).orNull)
      .build()
}
