package io.burkard.cdk.services.appflow

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnConnectorProfileProps {

  def apply(
    connectorProfileName: String,
    connectorType: String,
    connectionMode: String,
    connectorProfileConfig: Option[software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorProfileConfigProperty] = None,
    kmsArn: Option[String] = None
  ): software.amazon.awscdk.services.appflow.CfnConnectorProfileProps =
    (new software.amazon.awscdk.services.appflow.CfnConnectorProfileProps.Builder)
      .connectorProfileName(connectorProfileName)
      .connectorType(connectorType)
      .connectionMode(connectionMode)
      .connectorProfileConfig(connectorProfileConfig.orNull)
      .kmsArn(kmsArn.orNull)
      .build()
}
