package io.burkard.cdk.services.apigateway

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LambdaIntegrationOptions {

  def apply(
    requestParameters: Option[Map[String, String]] = None,
    credentialsPassthrough: Option[Boolean] = None,
    integrationResponses: Option[List[_ <: software.amazon.awscdk.services.apigateway.IntegrationResponse]] = None,
    cacheKeyParameters: Option[List[String]] = None,
    allowTestInvoke: Option[Boolean] = None,
    requestTemplates: Option[Map[String, String]] = None,
    cacheNamespace: Option[String] = None,
    credentialsRole: Option[software.amazon.awscdk.services.iam.IRole] = None,
    proxy: Option[Boolean] = None,
    vpcLink: Option[software.amazon.awscdk.services.apigateway.IVpcLink] = None,
    contentHandling: Option[software.amazon.awscdk.services.apigateway.ContentHandling] = None,
    passthroughBehavior: Option[software.amazon.awscdk.services.apigateway.PassthroughBehavior] = None,
    timeout: Option[software.amazon.awscdk.Duration] = None,
    connectionType: Option[software.amazon.awscdk.services.apigateway.ConnectionType] = None
  ): software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions =
    (new software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions.Builder)
      .requestParameters(requestParameters.map(_.asJava).orNull)
      .credentialsPassthrough(credentialsPassthrough.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .integrationResponses(integrationResponses.map(_.asJava).orNull)
      .cacheKeyParameters(cacheKeyParameters.map(_.asJava).orNull)
      .allowTestInvoke(allowTestInvoke.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .requestTemplates(requestTemplates.map(_.asJava).orNull)
      .cacheNamespace(cacheNamespace.orNull)
      .credentialsRole(credentialsRole.orNull)
      .proxy(proxy.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .vpcLink(vpcLink.orNull)
      .contentHandling(contentHandling.orNull)
      .passthroughBehavior(passthroughBehavior.orNull)
      .timeout(timeout.orNull)
      .connectionType(connectionType.orNull)
      .build()
}
