package io.burkard.cdk.services.amazonmq

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBroker {

  def apply(
    internalResourceId: String,
    users: List[_],
    deploymentMode: String,
    autoMinorVersionUpgrade: Boolean,
    brokerName: String,
    hostInstanceType: String,
    publiclyAccessible: Boolean,
    engineType: String,
    engineVersion: String,
    subnetIds: Option[List[String]] = None,
    tags: Option[List[_ <: software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty]] = None,
    maintenanceWindowStartTime: Option[software.amazon.awscdk.services.amazonmq.CfnBroker.MaintenanceWindowProperty] = None,
    storageType: Option[String] = None,
    authenticationStrategy: Option[String] = None,
    encryptionOptions: Option[software.amazon.awscdk.services.amazonmq.CfnBroker.EncryptionOptionsProperty] = None,
    configuration: Option[software.amazon.awscdk.services.amazonmq.CfnBroker.ConfigurationIdProperty] = None,
    securityGroups: Option[List[String]] = None,
    ldapServerMetadata: Option[software.amazon.awscdk.services.amazonmq.CfnBroker.LdapServerMetadataProperty] = None,
    logs: Option[software.amazon.awscdk.services.amazonmq.CfnBroker.LogListProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.amazonmq.CfnBroker =
    software.amazon.awscdk.services.amazonmq.CfnBroker.Builder
      .create(stackCtx, internalResourceId)
      .users(users.asJava)
      .deploymentMode(deploymentMode)
      .autoMinorVersionUpgrade(autoMinorVersionUpgrade)
      .brokerName(brokerName)
      .hostInstanceType(hostInstanceType)
      .publiclyAccessible(publiclyAccessible)
      .engineType(engineType)
      .engineVersion(engineVersion)
      .subnetIds(subnetIds.map(_.asJava).orNull)
      .tags(tags.map(_.asJava).orNull)
      .maintenanceWindowStartTime(maintenanceWindowStartTime.orNull)
      .storageType(storageType.orNull)
      .authenticationStrategy(authenticationStrategy.orNull)
      .encryptionOptions(encryptionOptions.orNull)
      .configuration(configuration.orNull)
      .securityGroups(securityGroups.map(_.asJava).orNull)
      .ldapServerMetadata(ldapServerMetadata.orNull)
      .logs(logs.orNull)
      .build()
}
