package io.burkard.cdk.services.route53

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHostedZoneProps {

  def apply(
    name: Option[String] = None,
    queryLoggingConfig: Option[software.amazon.awscdk.services.route53.CfnHostedZone.QueryLoggingConfigProperty] = None,
    hostedZoneConfig: Option[software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneConfigProperty] = None,
    vpcs: Option[List[_]] = None,
    hostedZoneTags: Option[List[_ <: software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty]] = None
  ): software.amazon.awscdk.services.route53.CfnHostedZoneProps =
    (new software.amazon.awscdk.services.route53.CfnHostedZoneProps.Builder)
      .name(name.orNull)
      .queryLoggingConfig(queryLoggingConfig.orNull)
      .hostedZoneConfig(hostedZoneConfig.orNull)
      .vpcs(vpcs.map(_.asJava).orNull)
      .hostedZoneTags(hostedZoneTags.map(_.asJava).orNull)
      .build()
}
