package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSMSChannel {

  def apply(
    internalResourceId: String,
    applicationId: String,
    enabled: Option[Boolean] = None,
    senderId: Option[String] = None,
    shortCode: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.pinpoint.CfnSMSChannel =
    software.amazon.awscdk.services.pinpoint.CfnSMSChannel.Builder
      .create(stackCtx, internalResourceId)
      .applicationId(applicationId)
      .enabled(enabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .senderId(senderId.orNull)
      .shortCode(shortCode.orNull)
      .build()
}
