package io.burkard.cdk.services.nimblestudio.cfnLaunchProfile

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StreamConfigurationProperty {

  def apply(
    clipboardMode: String,
    ec2InstanceTypes: List[String],
    streamingImageIds: List[String],
    maxSessionLengthInMinutes: Option[Number] = None
  ): software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationProperty =
    (new software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationProperty.Builder)
      .clipboardMode(clipboardMode)
      .ec2InstanceTypes(ec2InstanceTypes.asJava)
      .streamingImageIds(streamingImageIds.asJava)
      .maxSessionLengthInMinutes(maxSessionLengthInMinutes.orNull)
      .build()
}
