package io.burkard.cdk.services.location

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnMapProps {

  def apply(
    configuration: software.amazon.awscdk.services.location.CfnMap.MapConfigurationProperty,
    pricingPlan: String,
    mapName: String,
    description: Option[String] = None
  ): software.amazon.awscdk.services.location.CfnMapProps =
    (new software.amazon.awscdk.services.location.CfnMapProps.Builder)
      .configuration(configuration)
      .pricingPlan(pricingPlan)
      .mapName(mapName)
      .description(description.orNull)
      .build()
}
