package io.burkard.cdk.services.lightsail

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDatabaseProps {

  def apply(
    masterDatabaseName: String,
    relationalDatabaseBlueprintId: String,
    masterUsername: String,
    relationalDatabaseBundleId: String,
    relationalDatabaseName: String,
    backupRetention: Option[Boolean] = None,
    masterUserPassword: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    rotateMasterUserPassword: Option[Boolean] = None,
    availabilityZone: Option[String] = None,
    caCertificateIdentifier: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    relationalDatabaseParameters: Option[List[_]] = None,
    publiclyAccessible: Option[Boolean] = None,
    preferredBackupWindow: Option[String] = None
  ): software.amazon.awscdk.services.lightsail.CfnDatabaseProps =
    (new software.amazon.awscdk.services.lightsail.CfnDatabaseProps.Builder)
      .masterDatabaseName(masterDatabaseName)
      .relationalDatabaseBlueprintId(relationalDatabaseBlueprintId)
      .masterUsername(masterUsername)
      .relationalDatabaseBundleId(relationalDatabaseBundleId)
      .relationalDatabaseName(relationalDatabaseName)
      .backupRetention(backupRetention.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .masterUserPassword(masterUserPassword.orNull)
      .tags(tags.map(_.asJava).orNull)
      .rotateMasterUserPassword(rotateMasterUserPassword.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .availabilityZone(availabilityZone.orNull)
      .caCertificateIdentifier(caCertificateIdentifier.orNull)
      .preferredMaintenanceWindow(preferredMaintenanceWindow.orNull)
      .relationalDatabaseParameters(relationalDatabaseParameters.map(_.asJava).orNull)
      .publiclyAccessible(publiclyAccessible.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .preferredBackupWindow(preferredBackupWindow.orNull)
      .build()
}
