package io.burkard.cdk.services.lex

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBotVersionProps {

  def apply(
    botVersionLocaleSpecification: List[_],
    botId: String,
    description: Option[String] = None
  ): software.amazon.awscdk.services.lex.CfnBotVersionProps =
    (new software.amazon.awscdk.services.lex.CfnBotVersionProps.Builder)
      .botVersionLocaleSpecification(botVersionLocaleSpecification.asJava)
      .botId(botId)
      .description(description.orNull)
      .build()
}
