package io.burkard.cdk.services.kendra.cfnDataSource

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OneDriveConfigurationProperty {

  def apply(
    tenantDomain: String,
    oneDriveUsers: software.amazon.awscdk.services.kendra.CfnDataSource.OneDriveUsersProperty,
    secretArn: String,
    disableLocalGroups: Option[Boolean] = None,
    exclusionPatterns: Option[List[String]] = None,
    fieldMappings: Option[List[_]] = None,
    inclusionPatterns: Option[List[String]] = None
  ): software.amazon.awscdk.services.kendra.CfnDataSource.OneDriveConfigurationProperty =
    (new software.amazon.awscdk.services.kendra.CfnDataSource.OneDriveConfigurationProperty.Builder)
      .tenantDomain(tenantDomain)
      .oneDriveUsers(oneDriveUsers)
      .secretArn(secretArn)
      .disableLocalGroups(disableLocalGroups.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .exclusionPatterns(exclusionPatterns.map(_.asJava).orNull)
      .fieldMappings(fieldMappings.map(_.asJava).orNull)
      .inclusionPatterns(inclusionPatterns.map(_.asJava).orNull)
      .build()
}
