package io.burkard.cdk.services.glue.cfnSecurityConfiguration

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CloudWatchEncryptionProperty {

  def apply(
    cloudWatchEncryptionMode: Option[String] = None,
    kmsKeyArn: Option[String] = None
  ): software.amazon.awscdk.services.glue.CfnSecurityConfiguration.CloudWatchEncryptionProperty =
    (new software.amazon.awscdk.services.glue.CfnSecurityConfiguration.CloudWatchEncryptionProperty.Builder)
      .cloudWatchEncryptionMode(cloudWatchEncryptionMode.orNull)
      .kmsKeyArn(kmsKeyArn.orNull)
      .build()
}
