package io.burkard.cdk.services.globalaccelerator

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RawEndpoint {

  def apply(
    endpointId: String,
    region: Option[String] = None,
    weight: Option[Number] = None,
    preserveClientIp: Option[Boolean] = None
  ): software.amazon.awscdk.services.globalaccelerator.RawEndpoint =
    software.amazon.awscdk.services.globalaccelerator.RawEndpoint.Builder
      .create()
      .endpointId(endpointId)
      .region(region.orNull)
      .weight(weight.orNull)
      .preserveClientIp(preserveClientIp.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
