package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CloudMapOptions {

  def apply(
    name: Option[String] = None,
    containerPort: Option[Number] = None,
    container: Option[software.amazon.awscdk.services.ecs.ContainerDefinition] = None,
    dnsTtl: Option[software.amazon.awscdk.Duration] = None,
    failureThreshold: Option[Number] = None,
    dnsRecordType: Option[software.amazon.awscdk.services.servicediscovery.DnsRecordType] = None,
    cloudMapNamespace: Option[software.amazon.awscdk.services.servicediscovery.INamespace] = None
  ): software.amazon.awscdk.services.ecs.CloudMapOptions =
    (new software.amazon.awscdk.services.ecs.CloudMapOptions.Builder)
      .name(name.orNull)
      .containerPort(containerPort.orNull)
      .container(container.orNull)
      .dnsTtl(dnsTtl.orNull)
      .failureThreshold(failureThreshold.orNull)
      .dnsRecordType(dnsRecordType.orNull)
      .cloudMapNamespace(cloudMapNamespace.orNull)
      .build()
}
