package io.burkard.cdk.services.dlm.cfnLifecyclePolicy

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ScheduleProperty {

  def apply(
    name: Option[String] = None,
    copyTags: Option[Boolean] = None,
    retainRule: Option[software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.RetainRuleProperty] = None,
    crossRegionCopyRules: Option[List[_]] = None,
    tagsToAdd: Option[List[_]] = None,
    fastRestoreRule: Option[software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.FastRestoreRuleProperty] = None,
    deprecateRule: Option[software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.DeprecateRuleProperty] = None,
    shareRules: Option[List[_]] = None,
    variableTags: Option[List[_]] = None,
    createRule: Option[software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.CreateRuleProperty] = None
  ): software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.ScheduleProperty =
    (new software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.ScheduleProperty.Builder)
      .name(name.orNull)
      .copyTags(copyTags.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .retainRule(retainRule.orNull)
      .crossRegionCopyRules(crossRegionCopyRules.map(_.asJava).orNull)
      .tagsToAdd(tagsToAdd.map(_.asJava).orNull)
      .fastRestoreRule(fastRestoreRule.orNull)
      .deprecateRule(deprecateRule.orNull)
      .shareRules(shareRules.map(_.asJava).orNull)
      .variableTags(variableTags.map(_.asJava).orNull)
      .createRule(createRule.orNull)
      .build()
}
