package io.burkard.cdk.services.cognito

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnIdentityPool {

  def apply(
    internalResourceId: String,
    allowUnauthenticatedIdentities: Boolean,
    cognitoIdentityProviders: Option[List[_]] = None,
    cognitoEvents: Option[AnyRef] = None,
    allowClassicFlow: Option[Boolean] = None,
    identityPoolName: Option[String] = None,
    pushSync: Option[software.amazon.awscdk.services.cognito.CfnIdentityPool.PushSyncProperty] = None,
    cognitoStreams: Option[software.amazon.awscdk.services.cognito.CfnIdentityPool.CognitoStreamsProperty] = None,
    supportedLoginProviders: Option[AnyRef] = None,
    openIdConnectProviderArns: Option[List[String]] = None,
    samlProviderArns: Option[List[String]] = None,
    developerProviderName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.cognito.CfnIdentityPool =
    software.amazon.awscdk.services.cognito.CfnIdentityPool.Builder
      .create(stackCtx, internalResourceId)
      .allowUnauthenticatedIdentities(allowUnauthenticatedIdentities)
      .cognitoIdentityProviders(cognitoIdentityProviders.map(_.asJava).orNull)
      .cognitoEvents(cognitoEvents.orNull)
      .allowClassicFlow(allowClassicFlow.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .identityPoolName(identityPoolName.orNull)
      .pushSync(pushSync.orNull)
      .cognitoStreams(cognitoStreams.orNull)
      .supportedLoginProviders(supportedLoginProviders.orNull)
      .openIdConnectProviderArns(openIdConnectProviderArns.map(_.asJava).orNull)
      .samlProviderArns(samlProviderArns.map(_.asJava).orNull)
      .developerProviderName(developerProviderName.orNull)
      .build()
}
