package io.burkard.cdk.services.codeguruprofiler

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ProfilingGroup {

  def apply(
    internalResourceId: String,
    computePlatform: Option[software.amazon.awscdk.services.codeguruprofiler.ComputePlatform] = None,
    profilingGroupName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.codeguruprofiler.ProfilingGroup =
    software.amazon.awscdk.services.codeguruprofiler.ProfilingGroup.Builder
      .create(stackCtx, internalResourceId)
      .computePlatform(computePlatform.orNull)
      .profilingGroupName(profilingGroupName.orNull)
      .build()
}
