package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object NetworkUtilizationScalingProps {

  def apply(
    targetBytesPerSecond: Number,
    cooldown: Option[software.amazon.awscdk.Duration] = None,
    estimatedInstanceWarmup: Option[software.amazon.awscdk.Duration] = None,
    disableScaleIn: Option[Boolean] = None
  ): software.amazon.awscdk.services.autoscaling.NetworkUtilizationScalingProps =
    (new software.amazon.awscdk.services.autoscaling.NetworkUtilizationScalingProps.Builder)
      .targetBytesPerSecond(targetBytesPerSecond)
      .cooldown(cooldown.orNull)
      .estimatedInstanceWarmup(estimatedInstanceWarmup.orNull)
      .disableScaleIn(disableScaleIn.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
