package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnWarmPool {

  def apply(
    internalResourceId: String,
    autoScalingGroupName: String,
    minSize: Option[Number] = None,
    maxGroupPreparedCapacity: Option[Number] = None,
    poolState: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.autoscaling.CfnWarmPool =
    software.amazon.awscdk.services.autoscaling.CfnWarmPool.Builder
      .create(stackCtx, internalResourceId)
      .autoScalingGroupName(autoScalingGroupName)
      .minSize(minSize.orNull)
      .maxGroupPreparedCapacity(maxGroupPreparedCapacity.orNull)
      .poolState(poolState.orNull)
      .build()
}
