package io.burkard.cdk.services.voiceid

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDomain {

  def apply(
    internalResourceId: String,
    name: String,
    serverSideEncryptionConfiguration: software.amazon.awscdk.services.voiceid.CfnDomain.ServerSideEncryptionConfigurationProperty,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.voiceid.CfnDomain =
    software.amazon.awscdk.services.voiceid.CfnDomain.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .serverSideEncryptionConfiguration(serverSideEncryptionConfiguration)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .build()
}
