package io.burkard.cdk.services.signer

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SigningProfile {

  def apply(
    internalResourceId: String,
    platform: software.amazon.awscdk.services.signer.Platform,
    signatureValidity: Option[software.amazon.awscdk.Duration] = None,
    signingProfileName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.signer.SigningProfile =
    software.amazon.awscdk.services.signer.SigningProfile.Builder
      .create(stackCtx, internalResourceId)
      .platform(platform)
      .signatureValidity(signatureValidity.orNull)
      .signingProfileName(signingProfileName.orNull)
      .build()
}
